/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.widgets;

import org.eclipse.swt.*;
import org.eclipse.swt.events.*;

public class Link extends Control {
	String text = "";

public Link (Composite parent, int style) {
	super (parent, style);
}

public void addSelectionListener (SelectionListener listener) {
	checkWidget ();
	if (listener == null) error (SWT.ERROR_NULL_ARGUMENT);
	TypedListener typedListener = new TypedListener (listener);
	addListener (SWT.Selection,typedListener);
	addListener (SWT.DefaultSelection,typedListener);
}

public String getText () {
	checkWidget ();
	return text;
}

void hookEvents () {
	super.hookEvents();
	_hookClick("onclick",	SWT.Selection);
}

public void removeSelectionListener (SelectionListener listener) {
	checkWidget ();
	if (listener == null) error (SWT.ERROR_NULL_ARGUMENT);
	if (eventTable == null) return;
	eventTable.unhook (SWT.Selection, listener);
	eventTable.unhook (SWT.DefaultSelection,listener);	
}

public void setText (String string) {
	checkWidget ();
	if (string == null) error (SWT.ERROR_NULL_ARGUMENT);
	text = string;
	_setText (string);
}

/*---------------------- NATIVE INTERFACE -------------------*/

protected native void _createHandle (Widget parent, int style, int index) /*-{
	if(!$wnd.dojo._hasResource["org.eclipse.swt.Link"]){
		$wnd.dojo._hasResource["org.eclipse.swt.Link"] = true;
		$wnd.dojo.provide("org.eclipse.swt.Link");
		
		$wnd.dojo.require("dijit.form._FormWidget");
	
		$wnd.dojo.declare("org.eclipse.swt.Link", $wnd.dijit.form._FormWidget, {
			border: "",
			label: "",
			wrap: "",
			baseClass: "swtLink",
			templateString: '<div class="${baseClass}" baseClass="${baseClass}" dojoAttachPoint="containerNode, focusNode" id="${id}">${label}</div>',
			attributeMap: $wnd.dojo.mixin($wnd.dojo.clone($wnd.dijit.form._FormWidget.prototype.attributeMap),{label:this.containerNode}),
			postCreate: function(){
				this.inherited("postCreate",arguments);
				$wnd.swt.setCssStyle(this.domNode, {
					border: this.border,
					whiteSpace: this.wrap,
					overflow: "hidden"
				}); 
			},
			resize: function(dim){},
			setAlignment: function(alignment){
				this.domNode.align = alignment;
			},
			setLabel: function(content){
				this.containerNode.innerHTML = this.label = content;
				$wnd.dojo.forEach($wnd.dojo.query("a",this.containerNode), function(item){
					if(item && !item.href) {item.href=""};
				});
			}
		});
	}
	
	var jsParent = parent.@org.eclipse.swt.widgets.Widget::jsObject;
	params = {};
	if((style & (@org.eclipse.swt.SWT::BORDER)) != 0){
		params.border = "1px solid black";
	}
	var self = new $wnd.org.eclipse.swt.Link(params);
	try {
		this.@org.eclipse.swt.widgets.Widget::jsObject = self;
		jsParent.addChild(self);
	} catch (e) {
//TODO Have to throw real exception for Java side also	
		$wnd.console.log(e);
	}
}-*/;

native void _hookClick (String eventType, int style) /*-{
	var self = this;
	$wnd.dojo.connect(
		self.@org.eclipse.swt.widgets.Widget::jsObject.domNode,
		eventType, 
		function(arg){
			arg.preventDefault();
			if (arg.target.tagName=="A"){
				var event = self.@org.eclipse.swt.widgets.Widget::getEvent()();
				var text = ""; 
				if ($wnd.dojo.isIE) {
					text = arg.target.nameProp || arg.target.innerText;
				} else {
					var targetNode = arg.target.attributes.getNamedItem("href");
					text = targetNode.nodeValue || arg.target.text;
				}
				event.@org.eclipse.swt.widgets.Event::text = text;
				event.@org.eclipse.swt.widgets.Event::type = style;
				event.@org.eclipse.swt.widgets.Event::x = arg.pageX;
				event.@org.eclipse.swt.widgets.Event::y = arg.pageY;
				self.@org.eclipse.swt.widgets.Widget::sendEvent(ILorg/eclipse/swt/widgets/Event;)(style, event);
			}
		}
	);
}-*/;

native void _setText (String string) /*-{	
	this.@org.eclipse.swt.widgets.Widget::jsObject.setLabel(string);
}-*/;

}
